# 画面設計書 49-フォームレイアウト（Bootstrap 5）

## 概要

本ドキュメントは、Symfony Twig Bridgeが提供するBootstrap 5対応のフォームレイアウトテーマ（bootstrap_5_layout.html.twig）の画面設計書である。bootstrap_base_layoutを基盤として、Bootstrap 5のCSSクラスとコンポーネント構造を適用したフォーム要素のレンダリングを行う。

### 本画面の処理概要

**業務上の目的・背景**：Bootstrap 5はjQueryへの依存を廃止し、CSSカスタムプロパティの活用、RTLサポート、新しいユーティリティAPIなどの改善が行われた。bootstrap_5_layoutは、Bootstrap 5のデザインシステムに準拠したフォームレンダリングを提供する。Bootstrap 4からの主な変更点として、custom-controlクラスの廃止（form-checkに統合）、form-selectクラスの導入、visually-hiddenクラスの採用、form-floatingレイアウトのサポートなどがある。

**画面へのアクセス方法**：Symfonyの設定で`twig.form_themes`に`'bootstrap_5_layout.html.twig'`を指定する。

**主要な操作・処理内容**：
1. テキスト入力にform-controlクラスを適用（color→form-control-color追加、range→form-range）
2. バリデーションエラー時にis-invalidクラスを適用
3. ボタンにbtn-secondaryおよびbtnクラスを適用、送信ボタンにbtn-primary
4. チェックボックスをform-check/form-check-inline/form-switchで対応（btn-checkで ボタン化も可能）
5. ラジオボタンをform-check/form-check-inlineで対応（btn-checkでボタン化も可能）
6. セレクト要素にform-selectクラスを適用（Bootstrap 4のform-controlから変更）
7. エラー表示をinvalid-feedback/alert-dangerクラスのdivで表示（各エラーごとに独立div）
8. ヘルプテキストをform-textクラスのdivで表示（input-group時はinput-group-text）
9. ラベルにform-label/col-form-label/input-group-textクラスを適用（compoundではlegend要素）
10. フォーム行にmb-3クラスを適用（Bootstrap 4のform-groupから変更）
11. form-floatingレイアウト対応（ラベルとウィジェットの順序入れ替え）
12. input-groupレイアウト対応（ラベルをinput-group-textとして表示）
13. 日付/時刻ウィジェットでvisually-hiddenクラスを使用（Bootstrap 4のsr-onlyから変更）

**画面遷移**：本テーマファイル自体は画面遷移を定義しない。

**権限による表示制御**：テーマファイル自体には権限制御機能はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 34 | Form | 主機能 | Bootstrap 5対応のフォームレイアウトテーマによるフォームレンダリング |
| 36 | Twig Bridge | 主機能 | Twig Bridgeのフォームレンダリング拡張によるBootstrap 5用ブロック定義 |

## 画面種別

フォームテーマ（Twigテンプレート断片）

## URL/ルーティング

本テーマファイルは直接URLに紐づかない。

```yaml
twig:
    form_themes: ['bootstrap_5_layout.html.twig']
```

## 入出力項目

form_div_layoutと同一の共通変数に加え、以下のBootstrap 5固有変数を使用する。

| 変数名 | 型 | 説明 |
|--------|------|------|
| valid | bool | バリデーション結果（falseでis-invalidクラス適用） |
| parent_label_class | string | 親ラベルのCSSクラス（checkbox-inline/radio-inline/checkbox-switch判定用） |
| attr_class | string | ウィジェット要素のCSSクラス（btn-check判定用） |
| row_class | string | 行要素のCSSクラス（form-floating/input-group判定用） |
| label_attr_class | string | ラベル要素のCSSクラス（btn判定用） |

## 表示項目

### オーバーライドされた主要ブロック一覧

| ブロック名 | Bootstrap 5適用クラス | 説明 |
|-----------|---------------------|------|
| form_widget_simple | `form-control` / `form-control-color` / `form-range` | テキスト/カラー/レンジ入力 |
| widget_attributes | `is-invalid` | バリデーションエラー時の属性 |
| button_widget | `btn-secondary btn` | ボタン要素 |
| submit_widget | `btn-primary` | 送信ボタン |
| money_widget | `input-group` / `input-group-text` | 通貨記号付き入力（prepend/appendなし） |
| percent_widget | `input-group` / `input-group-text` | パーセント記号付き入力 |
| checkbox_widget | `form-check-input` / `form-check` / `form-check-inline` / `form-switch` | チェックボックス |
| radio_widget | `form-check-input` / `form-check` / `form-check-inline` | ラジオボタン |
| choice_widget_collapsed | `form-select` | セレクト要素（form-controlから変更） |
| form_label | `form-label` / `col-form-label` / `input-group-text` | ラベル |
| checkbox_radio_label | `form-check-label` | チェックボックス/ラジオのラベル |
| form_row_render | `mb-3` / `form-floating` / `input-group` | フォーム行 |
| button_row | `mb-3` | ボタン行 |
| form_errors | `invalid-feedback d-block` / `alert alert-danger d-block` | エラー表示（独立div） |
| form_help | `form-text mb-0` / `input-group-text` | ヘルプテキスト |
| date_widget | `visually-hidden` / `input-group` | 日付入力 |
| time_widget | `visually-hidden` / `input-group` | 時刻入力 |
| datetime_widget | `is-invalid` | 日時入力 |
| dateinterval_widget | `col-auto mb-3` | 期間入力 |

## イベント仕様

### 1-Bootstrap 5スタイルでのフォームレンダリング

主なHTML出力例：
```html
<!-- 通常フィールド -->
<div class="mb-3">
    <label class="form-label" for="form_name">Name</label>
    <input type="text" class="form-control" id="form_name" />
    <div class="form-text mb-0">Enter your name</div>
    <div class="invalid-feedback d-block">This value is required.</div>
</div>

<!-- form-floatingレイアウト -->
<div class="form-floating mb-3">
    <input type="text" class="form-control" id="form_email" placeholder="Email" />
    <label class="form-label" for="form_email">Email</label>
</div>

<!-- チェックボックス（スイッチ） -->
<div class="form-check form-switch">
    <input type="checkbox" class="form-check-input" id="form_active" />
    <label class="form-check-label" for="form_active">Active</label>
</div>

<!-- セレクト要素 -->
<div class="mb-3">
    <label class="form-label" for="form_country">Country</label>
    <select class="form-select" id="form_country">...</select>
</div>
```

### 2-form-floating対応

`row_attr.class`に`form-floating`が含まれる場合：
1. ウィジェットがラベルの前に配置される（Bootstrap 5のfloating labelの要件）
2. form-floatingクラスのdivでラップされる

### 3-input-group対応

`row_attr.class`に`input-group`が含まれる場合：
1. ラベルが`input-group-text`クラスで表示される
2. ヘルプテキストも`input-group-text`クラスで表示される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| フォームレンダリング | なし | なし | テンプレートはHTMLレンダリングのみ |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|-------------|------|-------------|
| バリデーションエラー | errors が存在する場合 | 各エラーごとにinvalid-feedback d-blockクラスのdivで表示（ルートフォームではalert alert-danger） |

## 例外処理

テーマテンプレート自体は例外をスローしない。

## 備考

- `{% use 'bootstrap_base_layout.html.twig' %}`により、Bootstrap共通基盤テーマを利用
- Bootstrap 4からの主な変更点：
  - form-group → mb-3
  - custom-control系 → form-check系に統合
  - form-control（セレクト） → form-select
  - sr-only → visually-hidden
  - input-group-prepend/append → 直接input-group-text
  - form-floatingレイアウトの新規サポート
  - input-groupレイアウトの改善サポート
- btn-checkクラスの検出により、チェックボックス/ラジオをボタンスタイルで表示可能
- form_row_renderブロックでform-floating/input-groupクラスを検出し、row_classから除去して適切なネスト構造を生成

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | FormView.php | `src/Symfony/Component/Form/FormView.php` | フォームビューの構造を理解する |

#### Step 2: 基盤テーマのチェーンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | form_div_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` | 最も基盤となるテーマ |
| 2-2 | bootstrap_base_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_base_layout.html.twig` | Bootstrap共通基盤テーマ |

#### Step 3: Bootstrap 5固有のオーバーライドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bootstrap_5_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_5_layout.html.twig` | Bootstrap 5固有のブロック定義を理解する |

**主要処理フロー**:
1. **L5-21**: `money_widget` - input-group-textによる通貨記号表示（prepend/appendなし）
2. **L23-52**: `date_widget` - visually-hidden + input-group構造
3. **L54-91**: `time_widget` - visually-hidden + input-group構造
4. **L93-108**: `datetime_widget` - is-invalidバリデーション対応
5. **L110-164**: `dateinterval_widget` - col-auto mb-3構造
6. **L166-175**: `percent_widget` - input-group-textによるパーセント表示
7. **L177-192**: `form_widget_simple` - form-control/form-control-color/form-rangeの振り分け
8. **L194-199**: `widget_attributes` - is-invalidクラスの条件付き適用
9. **L201-209**: `button_widget`/`submit_widget` - btn-secondary/btn-primaryの適用
10. **L211-233**: `checkbox_widget` - form-check/form-check-inline/form-switch/btn-checkの振り分け
11. **L235-254**: `radio_widget` - form-check/form-check-inline/btn-checkの振り分け
12. **L256-259**: `choice_widget_collapsed` - form-selectクラスの適用
13. **L275-292**: `form_label` - form-label/col-form-label/input-group-textの振り分け
14. **L294-319**: `checkbox_radio_label` - form-check-label/btn判定
15. **L323-339**: `form_row_render` - mb-3/form-floating/input-group対応
16. **L349-355**: `form_errors` - invalid-feedback d-block/alert alert-dangerの各エラー独立div
17. **L359-370**: `form_help` - form-text mb-0/input-group-textの切り替え

### プログラム呼び出し階層図

```
{{ form_row(form.field) }}
    |
    +-- form_row [form_div_layoutから継承]
    |       +-- aria属性の計算
    |       +-- form_row_render [bootstrap_5_layout オーバーライド]
    |               |
    |               +-- [form-floating] <div class="form-floating mb-3">
    |               |       +-- form_widget → form_widget_simple
    |               |       +-- form_label → <label class="form-label">
    |               |       +-- form_help / form_errors
    |               |
    |               +-- [input-group] <div class="mb-3">
    |               |       +-- form_label → <label class="input-group-text">
    |               |       +-- form_widget
    |               |       +-- form_help → <div class="input-group-text">
    |               |       +-- form_errors
    |               |
    |               +-- [通常] <div class="mb-3">
    |                       +-- form_label → <label class="form-label">
    |                       +-- form_widget → <input class="form-control">
    |                       +-- form_help → <div class="form-text mb-0">
    |                       +-- form_errors → <div class="invalid-feedback d-block">
```

### データフロー図

```
[入力]                          [処理]                              [出力]

FormView ---------> TwigRendererEngine ---------> ブロック解決
(+ row_attr:                                        |
  form-floating,    テーマ検索順序:                    v
  input-group等)    1. bootstrap_5_layout       Bootstrap 5 CSSクラス付きHTML
                    2. bootstrap_base_layout    (<div class="mb-3">,
                    3. form_div_layout           <input class="form-control">,
                                                 <select class="form-select">,
                                                 <div class="form-check">, ...)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bootstrap_5_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_5_layout.html.twig` | テンプレート | Bootstrap 5対応フォームテーマ（全371行） |
| bootstrap_base_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_base_layout.html.twig` | テンプレート | Bootstrap共通基盤テーマ（全209行） |
| form_div_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` | テンプレート | 最も基盤となるフォームレイアウトテーマ（全482行） |
